/**
 * 顶部导航栏组件 - 参考百度网盘设计
 */
(function() {
    'use strict';
    
    const { ref, computed } = typeof Vue !== 'undefined' ? Vue : {};
    
    if (!Vue) {
        console.error('Vue is not loaded');
        return;
    }
    
    window.TopBar = {
        props: {
            currentPath: {
                type: String,
                default: '全部文件'
            },
            storageInfo: {
                type: Object,
                default: () => ({ used: 0, total: 0 })
            }
        },
        emits: ['search', 'new-folder', 'upload'],
        template: `
            <div class="disk-topbar">
                <div class="topbar-left">
            

                    <!-- Logo -->
                    <div class="topbar-logo">
                        <img src="src/components/icon.png" alt="IDDisk Logo" class="logo-icon" />
                        <span class="logo-text">IDDisk</span>
                    </div>
                    
                   
                </div>
                
                <div class="topbar-center">
                  
                </div>
                
                <div class="topbar-right">
                    <!-- 用户操作栏 -->
                    <div class="topbar-user-operate">
                        <slot name="user-operate"></slot>
                    </div>
                </div>
            </div>
        `,
        setup(props, { emit }) {
            const searchKeyword = ref('');
            
            const storagePercentage = computed(() => {
                if (!props.storageInfo.total || props.storageInfo.total === 0) return 0;
                return Math.round((props.storageInfo.used / props.storageInfo.total) * 100);
            });
            
            const formatStorage = (bytes) => {
                if (!bytes || bytes === 0) return '0 B';
                const k = 1024;
                const sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
                const i = Math.floor(Math.log(bytes) / Math.log(k));
                return Math.round((bytes / Math.pow(k, i)) * 100) / 100 + ' ' + sizes[i];
            };
            
            const handleSearch = () => {
                emit('search', searchKeyword.value);
            };
            
            return {
                searchKeyword,
                storagePercentage,
                formatStorage,
                handleSearch
            };
        }
    };
})();

