/**
 * 侧边栏组件 - 参考百度网盘设计
 */
(function() {
    'use strict';
    
    const { ref, computed } = typeof Vue !== 'undefined' ? Vue : {};
    
    if (!Vue) {
        console.error('Vue is not loaded');
        return;
    }
    
    window.Sidebar = {
        props: {
            selectedCategory: {
                type: String,
                default: 'all'
            }
        },
        emits: ['update:selectedCategory', 'category-change'],
        template: `
            <div class="disk-sidebar">
                <div class="sidebar-header">
                    <h3 class="sidebar-title">
                        <el-icon class="mr-2"><FolderOpened /></el-icon>
                        我的文件
                    </h3>
                </div>
                
                <div class="sidebar-menu">
                    <div 
                        v-for="item in menuItems" 
                        :key="item.value"
                        :class="['sidebar-menu-item', { 'is-active': selectedCategory === item.value }]"
                        @click="handleCategoryChange(item.value)">
                        <el-icon class="sidebar-menu-icon" :size="20">
                            <component :is="item.icon" />
                        </el-icon>
                        <span class="sidebar-menu-label">{{ item.label }}</span>
                        
                    </div>
                </div>
                
                <div class="sidebar-divider"></div>
                
                <div class="sidebar-section">
                    <div class="sidebar-section-title">分类</div>
                    <div class="sidebar-menu">
                        <div 
                            v-for="item in categoryItems" 
                            :key="item.value"
                            :class="['sidebar-menu-item', { 'is-active': selectedCategory === item.value }]"
                            @click="handleCategoryChange(item.value)">
                            <el-icon class="sidebar-menu-icon" :size="20" :color="item.color">
                                <component :is="item.icon" />
                            </el-icon>
                            <span class="sidebar-menu-label">{{ item.label }}</span>
                            <span v-if="item.count !== undefined" class="sidebar-menu-count">{{ item.count }}</span>
                        </div>
                    </div>
                </div>
            </div>
        `,
        setup(props, { emit }) {
            const menuItems = ref([
                { value: 'all', label: '全部文件', icon: 'Folder', count: 0 },
                { value: 'recent', label: '最近', icon: 'Clock', count: 0 },
                { value: 'starred', label: '收藏', icon: 'Star', count: 0 },
                { value: 'shared', label: '分享', icon: 'Share', count: 0 },
                // { value: 'trash', label: '回收站', icon: 'Delete', count: 0 }
            ]);
            
            const categoryItems = ref([
                { value: 'image', label: '图片', icon: 'Picture', color: '#67C23A' },
                { value: 'video', label: '视频', icon: 'VideoPlay', color: '#409EFF' },
                { value: 'audio', label: '音频', icon: 'Headset', color: '#E6A23C' },
                { value: 'document', label: '文档', icon: 'Document', color: '#F56C6C' },
                { value: 'spreadsheet', label: '表格', icon: 'Grid', color: '#67C23A' },
                { value: 'presentation', label: '演示文稿', icon: 'DataBoard', color: '#E6A23C' },
                { value: 'archive', label: '压缩包', icon: 'Box', color: '#909399' },
                { value: 'code', label: '代码', icon: 'Document', color: '#606266' }
            ]);
            
            const handleCategoryChange = (value) => {
                emit('update:selectedCategory', value);
                emit('category-change', value);
            };
            
            return {
                menuItems,
                categoryItems,
                handleCategoryChange
            };
        }
    };
})();








