/**
 * 文件工具栏组件 - 参考图片设计
 */
(function() {
    'use strict';
    
    const { ref, computed, onMounted, onUnmounted } = typeof Vue !== 'undefined' ? Vue : {};
    
    if (!Vue) {
        console.error('Vue is not loaded');
        return;
    }
    
    window.FileToolbar = {
        props: {
            selectedFileType: {
                type: String,
                default: 'all'
            },
            sortBy: {
                type: String,
                default: 'date-desc'
            },
            viewMode: {
                type: String,
                default: 'grid'
            },
            selectedCount: {
                type: Number,
                default: 0
            },
            isSelectionMode: {
                type: Boolean,
                default: false
            }
        },
        emits: ['update:selectedFileType', 'update:sortBy', 'update:viewMode', 'upload', 'refresh', 'new-folder', 'new-note', 'search', 'share', 'download-selected', 'more-actions', 'cancel-selection'],
        template: `
            <div class="file-toolbar" :class="{ 'is-mobile': isMobile, 'is-selection-mode': isSelectionMode }">
                <!-- 选择模式工具栏 -->
                <template v-if="isSelectionMode">
                    <div class="file-toolbar-selection">
                        <div class="file-toolbar-selection-left">
                            <span class="selection-count">已选择{{ selectedCount }}张</span>
                        </div>
                        <div class="file-toolbar-selection-right">
                            <el-button 
                                class="toolbar-selection-btn"
                                @click="$emit('share')">
                                <el-icon><Share /></el-icon>
                                <span>分享</span>
                            </el-button>
                            <el-button 
                                class="toolbar-selection-btn"
                                @click="$emit('download-selected')">
                                <el-icon><Download /></el-icon>
                                <span>下载</span>
                            </el-button>
                            <el-button 
                                class="toolbar-selection-btn"
                                @click="$emit('more-actions')">
                                <el-icon><MoreFilled /></el-icon>
                                <span>更多</span>
                            </el-button>
                            <el-button 
                               
                                class="toolbar-selection-btn"
                                @click="$emit('cancel-selection')">
                                取消选择
                            </el-button>
                        </div>
                    </div>
                </template>
                
                <!-- 正常模式工具栏 -->
                <template v-else>
                    <!-- 移动端：搜索框在最上面 -->
                    <div v-if="isMobile" class="file-toolbar-search-mobile">
                        <div class="file-toolbar-search">
                            <el-input
                                v-model="searchKeyword"
                                placeholder="输入你要搜索的文件名"
                                class="toolbar-search-input"
                                clearable
                                @keyup.enter="handleSearch">
                                <template #prefix>
                                    <el-icon><Search /></el-icon>
                                </template>
                            </el-input>
                        </div>
                    </div>
                    
                    <!-- 桌面端：原有布局 -->
                    <template v-if="!isMobile">
                        <!-- 左侧：上传按钮（大按钮） -->
                        <div class="file-toolbar-left">
                            <el-button 
                                type="primary" 
                                size="large"
                                class="upload-btn-large"
                                @click="$emit('upload')">
                                <el-icon><Upload /></el-icon>
                                <span class="ml-1">上传</span>
                            </el-button>
                            
                            <!-- 按钮组：新建文件夹、新建笔记 -->
                            <div class="file-toolbar-button-group">
                                <el-button 
                                    class="toolbar-btn-group-item"
                                    @click="$emit('new-folder')">
                                    <el-icon><FolderAdd /></el-icon>
                                    <span class="ml-1">新建文件夹</span>
                                </el-button>
                                <div class="toolbar-btn-divider"></div>
                                <el-button 
                                    class="toolbar-btn-group-item"
                                    @click="$emit('new-note')">
                                    <el-icon><DocumentAdd /></el-icon>
                                    <span class="ml-1">新建笔记</span>
                                </el-button>
                            </div>
                        </div>
                        
                        <!-- 右侧：搜索框 -->
                        <div class="file-toolbar-right">
                            <div class="file-toolbar-search">
                                <el-input
                                    v-model="searchKeyword"
                                    placeholder="搜索我的文件"
                                    class="toolbar-search-input"
                                    clearable
                                    @keyup.enter="handleSearch">
                                </el-input>
                                <el-button 
                                    type="primary" 
                                    class="toolbar-search-btn"
                                    @click="handleSearch">
                                    搜索
                                </el-button>
                            </div>
                        </div>
                    </template>
                </template>
            </div>
        `,
        setup(props, { emit }) {
            const searchKeyword = ref('');
            const isMobile = ref(false);
            
            const checkMobile = () => {
                isMobile.value = window.innerWidth < 500;
            };
            
            onMounted(() => {
                checkMobile();
                window.addEventListener('resize', checkMobile);
            });
            
            onUnmounted(() => {
                window.removeEventListener('resize', checkMobile);
            });
            
            const handleSearch = () => {
                emit('search', searchKeyword.value);
            };
            
            return {
                searchKeyword,
                isMobile,
                handleSearch
            };
        }
    };
})();

