/**
 * 文件类型筛选组件
 */
(function() {
    'use strict';
    
    const { ref, computed, onMounted } = typeof Vue !== 'undefined' ? Vue : {};
    
    if (!Vue || !window.useFileTypes) {
        console.error('Vue or useFileTypes is not loaded');
        return;
    }
    
    window.FileTypeFilter = {
        props: {
            modelValue: {
                type: String,
                default: 'all'
            }
        },
        emits: ['update:modelValue', 'change'],
        template: `
            <div class="file-type-filter">
                <el-radio-group 
                    :model-value="modelValue" 
                    @update:model-value="handleChange"
                    class="file-type-radio-group"
                    size="default">
                    <el-radio-button 
                        v-for="type in fileTypeList" 
                        :key="type.value"
                        :label="type.value"
                        class="file-type-radio">
                        <el-icon class="mr-1" v-if="type.icon">
                            <component :is="type.icon" />
                        </el-icon>
                        <span class="hidden sm:inline">{{ type.label }}</span>
                    </el-radio-button>
                </el-radio-group>
            </div>
        `,
        setup(props, { emit }) {
            const { fileTypeList } = window.useFileTypes();
            
            const handleChange = (value) => {
                emit('update:modelValue', value);
                emit('change', value);
            };
            
            return {
                fileTypeList,
                handleChange
            };
        }
    };
})();

