/**
 * 文件工具函数 Hook
 * 提供文件相关的工具函数
 */
(function() {
    'use strict';
    
    window.useFileUtils = function() {
        // 格式化文件大小
        const formatFileSize = (bytes) => {
            if (!bytes || bytes === 0) return '0 B';
            const k = 1024;
            const sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return Math.round((bytes / Math.pow(k, i)) * 100) / 100 + ' ' + sizes[i];
        };
        
        // 格式化日期
        const formatDate = (timestamp) => {
            if (!timestamp) return '-';
            
            // 处理时间戳格式：13位毫秒、10位秒、或其他格式
            let formatTime;
            const timestampStr = String(timestamp);
            if (timestampStr.length === 13) {
                formatTime = timestamp;
            } else if (timestampStr.length === 10) {
                formatTime = timestamp * 1000;
            } else {
                formatTime = parseInt(timestampStr) * 1000;
            }
            
            const date = new Date(formatTime);
            const now = new Date();
            
            // 获取日期部分（年-月-日），忽略时间部分
            const dateOnly = new Date(date.getFullYear(), date.getMonth(), date.getDate());
            const nowOnly = new Date(now.getFullYear(), now.getMonth(), now.getDate());
            
            // 计算日期差（天数）
            const diffTime = nowOnly - dateOnly;
            const days = Math.floor(diffTime / (1000 * 60 * 60 * 24));
            
            if (days === 0) {
                return '今天 ' + date.toLocaleTimeString('zh-CN', { hour: '2-digit', minute: '2-digit' });
            } else if (days === 1) {
                return '昨天 ' + date.toLocaleTimeString('zh-CN', { hour: '2-digit', minute: '2-digit' });
            } else if (days < 7) {
                return days + '天前';
            } else {
                return date.toLocaleDateString('zh-CN', {
                    year: 'numeric',
                    month: '2-digit',
                    day: '2-digit',
                    hour: '2-digit',
                    minute: '2-digit'
                });
            }
        };
        
        // 获取文件扩展名
        const getFileExtension = (fileName) => {
            if (!fileName) return '';
            const parts = fileName.split('.');
            return parts.length > 1 ? parts.pop().toLowerCase() : '';
        };
        
        // 获取文件名（不含扩展名）
        const getFileNameWithoutExtension = (fileName) => {
            if (!fileName) return '';
            const lastDot = fileName.lastIndexOf('.');
            return lastDot > 0 ? fileName.substring(0, lastDot) : fileName;
        };
        
        return {
            formatFileSize,
            formatDate,
            getFileExtension,
            getFileNameWithoutExtension
        };
    };
})();


