/**
 * 文件排序组件
 */
(function() {
    'use strict';
    
    const { ref, computed } = typeof Vue !== 'undefined' ? Vue : {};
    
    if (!Vue || !window.useFileSort) {
        console.error('Vue or useFileSort is not loaded');
        return;
    }
    
    window.FileSort = {
        props: {
            modelValue: {
                type: String,
                default: 'date-desc'
            }
        },
        emits: ['update:modelValue', 'change'],
        template: `
            <div class="file-sort">
                <el-select 
                    :model-value="modelValue"
                    @update:model-value="handleChange"
                    placeholder="排序方式"
                    size="default"
                    class="file-sort-select">
                    <el-option
                        v-for="option in sortOptions"
                        :key="option.value"
                        :label="option.label"
                        :value="option.value">
                    </el-option>
                </el-select>
            </div>
        `,
        setup(props, { emit }) {
            const { sortOptions } = window.useFileSort();
            
            const handleChange = (value) => {
                emit('update:modelValue', value);
                emit('change', value);
            };
            
            return {
                sortOptions,
                handleChange
            };
        }
    };
})();





